/*Jquery Plugin
Created - Gunjan Kothari
Updated - Felipe Vargas 
Date - 24/04/2014
Date updated 18/09/2014
Plugin to Draw a line between to elements*/



(function($) {
	$.fn.connectSVG = function(param) {
		var _canvas;
		var _ctx;
		var _lines = new Array(); //This array will store all lines (option)
		var _me = this;
		var _parent = param || document;

		//Initialize Canvas object
		_canvas = $('<canvas/>')
			.attr('width', $(this).width())
			.attr('height', $(this).height());
		$(this).append(_canvas);


		var drawFlag = false;
		this.selected = false;
		var origenDiv;
		this.positionX;
		this.positionY;


		this.drawLine = function(option) {
			//It will push line to array.

			//Add to the option the coordinates x,y for drawing the line
			calculateCoordinates(option);
			_lines.push(option);
			//this.connect(option);
		};
		this.drawAllLine = function(option) {

			/*Mandatory Fields------------------
			left_selector = '.class',
			data_attribute = 'data-right',
			*/

			if (option.left_selector != '' && typeof option.left_selector !== 'undefined' && $(option.left_selector).length > 0) {
				$(option.left_selector).each(function(index) {
					var option2 = new Object();
					$.extend(option2, option);
					option2.left_node = $(this).attr('id');
					option2.right_node = $(this).data(option.data_attribute);
					if (option2.right_node != '' && typeof option2.right_node !== 'undefined') {
						_me.drawLine(option2);

					}
				});
			}
		};

		//This Function is used to connect two different div with a dotted line.
		this.connect = function(option) {
			_ctx = _canvas[0].getContext('2d');
			_ctx.beginPath();
			try {
				var _color = option.color;
				var _dash;
				var _left = new Object(); //This will store _left elements offset  
				var _right = new Object(); //This will store _right elements offset	
				var _error = (option.error == 'show') || false;
				/*
			option = {
				left_node - Left Element by ID - Mandatory
				right_node - Right Element ID - Mandatory
				status - accepted, rejected, modified, (none) - Optional
				style - (dashed), solid, dotted - Optional	
				horizantal_gap - (0), Horizantal Gap from original point
				error - show, (hide) - To show error or not
				width - (2) - Width of the line
			}
			*/



				//To decide style of the line. dotted or solid
				switch (option.style) {
					case 'dashed':
						_dash = [4, 2];
						break;

					case 'solid':
						_dash = [0, 0];
						break;

					case 'dotted':
						_dash = [4, 2];
						break;

					default:
						_dash = [4, 2];
						break;
				}

				//If left_node is actually right side, following code will switch elements.


				//Draw Line
				var _gap = option.horizantal_gap || 0;


				_ctx.moveTo(option.leftX, option.leftY);
				if (_gap != 0) {
					_ctx.lineTo(option.leftX + _gap, option.leftY);
					_ctx.lineTo(option.rightX - _gap, option.rightY);
				}
				_ctx.lineTo(option.rightX, option.rightY);

				if (!_ctx.setLineDash) {
					_ctx.setLineDash = function() {}
				} else {
					_ctx.setLineDash(_dash);
				}
				_ctx.lineWidth = option.width || 2;
				_ctx.strokeStyle = _color;
				_ctx.stroke();

				//option.resize = option.resize || false;

			} catch (err) {
				if (_error) alert('Mandatory Fields are missing or incorrect');
			}
		};


		this.redrawLines = function() {

			_ctx = _canvas[0].getContext('2d');
			//_ctx.clearRect(0, 0, $(_parent).width(), $(_parent).height());
			_ctx.clearRect(0, 0, _canvas.attr('width'),_canvas.attr('height'));
			
			// console.log("cantidad de lineas:::" + _lines.length);
			// console.log(_lines);
			_lines.forEach(function(entry) {
				//entry.resize = true;
				console.log("lineas");
				console.log(entry);
				_me.connect(entry);
			});
		};


		this.mousePositionLine = function(xInit, yInit, xFinal, yFinal) {



			_ctx = _canvas[0].getContext('2d');


			//_ctx.clearRect(0, 0, $(_parent).width(), $(_parent).height());
			_ctx.beginPath();

			_ctx.setLineDash([4, 2]);
			_ctx.lineTo(xInit, yInit);
			_ctx.lineTo(xFinal, yFinal);
			_ctx.lineWidth = 2;

			_ctx.strokeStyle = 'red';
			_ctx.stroke();

		}

		this.setSelectDivInit = function(beginDiv) {
			this.selected = true;
		}

		this.removeSelectDivInit = function() {

			this.selected = false;
		}

		var calculateCoordinates = function(option) {

			_left_node = $(option.left_node);
			_right_node = $(option.right_node);
			if (_left_node.offset().left >= _right_node.offset().left) {
				_tmp = _left_node
				_left_node = _right_node
				_right_node = _tmp;
			}

			//Get Left point and Right Point

			option.leftX = _left_node.position().left + _left_node.outerWidth();
			option.leftY = _left_node.position().top + (_left_node.outerHeight() / 2);
			option.rightX = _right_node.position().left;
			option.rightY = _right_node.position().top + (_right_node.outerHeight() / 2);
		}
		return this;
	};
}(jQuery));