'use strict';

/**
@author
A module representing the  scalation in the screen
@Module scaleScreen  
**/
define(['jquery', 'json', 'sgPopUp'], function($, JSON3, sgPopUp) {


	var app = {};
	var $stage;


	function getMsize(target) {
		var h = 0;
		var $this = $(target);
		h += pxToNum($this.css("padding-top")) + pxToNum($this.css("padding-bottom"));
		h += pxToNum($this.css("margin-top")) + pxToNum($this.css("margin-bottom"));
		h += pxToNum($this.css("border-top-width")) + pxToNum($this.css("border-bottom-width"));
		return h;
	}
	var getStageScale = function() {
		var matrixStr = $stage.css("transform");
		if (matrixStr) {

			var aux = $stage.css("transform").replace("matrix(", "[").replace(")", "]");
			var aux2 = $stage.css("transform");
			
			var matrix = JSON.parse(aux);
			
			sg.scaleX = matrix[0];
			sg.scaleY = matrix[3];
		} else {
			sg.scaleX = sg.scaleY = 0;
		}
	}

	var setScaleStyle = function($target, scalemode) {
		var ww = window.innerWidth;
		var hh = window.innerHeight;

		switch (scalemode) {
			case "showall":
				var msc = Math.min(ww / sg.sw, hh / sg.sh);

				$target.css({
					"-ms-transform":"scale(" + msc + ")",
					"-webkit-transform": "scale(" + msc + ")",
					"transform": "scale(" + msc + ")",
					"transform-origin": "0 0",
					"left": ((ww - sg.sw * msc) * 0.5) + "px",
					"top": ((hh - sg.sh * msc) * 0.5) + "px"
				});
				//$target.parent().height($target.height()*msc);
				break;

			case "noscale":
				break;

			case "exactfit":
				$target.css({
					"transform": "scale(" + (ww / sg.sw) + "," + (hh / sg.sh) + ")",
					"transform-origin": "0 0"
				});
				break;
		}
	};

	var setStageScaleStyle = function($target, scalemode) {
		$stage = $target;
		var ww = window.innerWidth;
		var hh = window.innerHeight;
		var ch = $content.height() + pxToNum($content.css("margin-top")) + pxToNum($content.css("margin-bottom"));
		switch (scalemode) {
			case "showall":

				var msc = Math.min(ww / sg.sw, hh / sg.sh);

				//stage높이보다 content높이가 크다면, 컨텐츠의 일부가 보여질때는 top 0 부터 정렬하면서 스크롤가능하게하고,
				//컨텐츠의 전부가 보여질때는 세로 가운데정렬 하면서 스크롤을 없애자
				//console.log(ch, sg.sh);
				//if(ch>=sg.sh){
				if (ch - sg.sh <= 1) { //오차 1허용
					if (ch * msc > hh) {
						//console.log("top 0, overflow:visible");
						$target.css({
							"transform": "scale(" + msc + ")",
							"transform-origin": "0 0",
							"left": ((ww - sg.sw * msc) * 0.5) + "px",
							"top": 0
						});
						$target.parent().css({
							"overflow-y": "visible"
						});
					} else {
						//console.log("top center, overflow:hidden");
						$target.css({
							"transform": "scale(" + msc + ")",
							"transform-origin": "0 0",
							"left": ((ww - sg.sw * msc) * 0.5) + "px",
							"top": ((hh - ch * msc) * 0.5) + "px"
						});

						$target.parent().css({
							"overflow-y": "hidden"
						});

						
					}
				} else {
					//console.log("top center, overflow:auto");
					$target.css({
						"transform": "scale(" + msc + ")",
						"transform-origin": "0 0",
						"left": ((ww - sg.sw * msc) * 0.5) + "px",
						"top": ((hh - sg.sh * msc) * 0.5) + "px"
					});
					$target.parent().css({
						"overflow-y": "auto"
					});

					
				}


				//$target.parent().height($target.height()*msc);
				break;

			case "noscale":
				break;

			case "exactfit":
				$target.css({
					"transform": "scale(" + (ww / sg.sw) + "," + (hh / sg.sh) + ")",
					"transform-origin": "0 0"
				});
				break;
		}
	};


	app.init = function(stage) {

		$stage = stage;
		if ($stage.length) {
			sg.sw = $stage.width();
			sg.sh = $stage.height();

			/*
                     //컨텐츠배경사이즈를 스테이지에 맞추는과정
                     */
			//header의 크기를 제외한 나머지 크기만큼을 내용배경의 높이로 잡아서, 배경의 최소높이를 스테이지의 높이에 맞춘다.
			var acH = 0;
			var $header = $("header");
			var $window = $(window);
			$content.children().each(function(i, e) {
				//console.log(e);
				acH += getMsize(e);
			});
			acH += $header.height();
			acH += getMsize($content) + 1;

			$(".gga_contenido, .ggb_contenido, .ggc_contenido, .ggd_contenido, .gge_contenido").css("min-height", sg.sh - acH);

			var scalemode = sg.scaleMode = $stage.attr("data-sg-scalemode");
			//         $body.css("overflow-x", "hidden");
			$window.bind("resize", function(e) {
				setStageScaleStyle($stage, scalemode);
				
				if (sgPopUp.$currentPopup != undefined) {
					//setScaleStyle($currentPopup, sg.scaleMode);
					sgPopUp.popupScaleStyle();
				}
				getStageScale();
			});
			setStageScaleStyle($stage, scalemode);
			getStageScale();
		} else {
			sg.sw = 0;
			sg.sh = 0;
		}
	}


	return app;
});