'use strict';

/**
@author
A module representing the  html buttons all the general events  necessaries for that component
@Module buttonsManager  
**/
define(['jquery', 'sgSound'], function($, sgSound) {

    var app = {};

    app.init = function() {


        $("[data-sg-click], [data-sg-one]")
            .each(function(i, e) {
                app.btnInit(this);
                sgSound.sg_sound(this, false);
            })
            .click(function() {
                var $me = $(this);
                var oneCom = $me.attr("data-sg-one");
                var com = $me.attr("data-sg-click");
                var options = $me.data("options");
                if (!options.enabled) return;
                if (oneCom) {
                    eval(oneCom);
                    $me.attr("data-sg-one", null);
                    if (!com) $me.unbind("click").css("cursor", "auto");
                }
                if (com) eval(com);
                sgSound.sg_sound(this);
                //반복실행가능 여부
                if (options.loop == false) $me.unbind("click").css("cursor", "auto");
            });


        $("[data-sg-id=btn-hide]")
            .each(function(i, e) {
                app.btnInit(this);
                var $me = $(this);

                var $toggle = $me.find("[data-sg-id=btn-toggle]");

                //Different to undefined
                if ($toggle){
                    //It should be vissible and out of the span $child, 
                    //It should be in data "toggle" to be consulted when 
                    // a click event is triggered.
                    $toggle.css("visibility", "visible");
                    $toggle = $toggle.detach();
                    $me.data("$toggle", $toggle);
                }

                var $child = $('<span></span>');
                $child.html($me.html()).css("visibility", "hidden").html();
                $me.html("").append($child);
                var options = $me.data("options");
                $me.data("visible", options.visible || false); //undefined라면 false넣기위해
                $me.data("$child", $child);

                //If toggle is differet to undefined it has to be 
                //append to the main div and show
                if($toggle) $me.append($toggle); 

                //onimg 동기화
                sg_onImg(this, options.visible);

                //스왑이미지 프리로드
                sg_swapImg(this, true);

                //음원속성이 있다면 프리로드           
                sgSound.sg_sound(this, false);
            }).click(function(e) {

                var $me = $(this);
                //console.log($me.data("key"));
                var options = $me.data("options");
                if (!options.enabled) return;

                var $child = $me.data("$child");
                var flag = $me.data("visible");
                //console.log($child);
                //console.log(flag?"hidden":"visible");

                //Here the toggle element has to be test and show or hide whatever 
                //situation that could be. 
                var $toggle = $me.data("$toggle");
                $toggle.css("visibility", flag? "visible" : "hidden");

                $child.css("visibility", flag ? "hidden" : "visible");
                $me.data("visible", !flag);

                //반복실행가능 여부
                if (options.loop == false) $me.unbind("click").css("cursor", "auto");

                //visible값을 이미지 숨김 보임으로 연결
                sg_onImg(this, !flag);

                //연결된 이미지를 swap기능 수행
                sg_swapImg(this, true);

                //실행 스크립트
                sg_call(this);

                //음원속성이 있다면 재생
                sgSound.sg_sound(this);
            }).bind("mousedown", function() {
                return false;
            });


        $("[data-sg-id=overlap]")
            .each(function(i, e) {
                $(this).children(":not(:eq(0))").hide();
            });
        //속성에 sg-click이 있는 태그들의 버튼동작 설정
        $("[data-sg-init]")
            .each(function(i, e) {
                var com = $(this).attr("data-sg-init");
                if (com) eval(com);
            });
    }

    //인터렉션 요소의 옵션을 json으로 파싱
    function getOptions(element) {
        if (!element) {
            throw "getOptions에서 element값이 " + element;
            return;
        }
        //옵션이 없을 경우 입힐 기본옵션 정의
        var defaultOptions = {
            loop: true, //인터렉션 요소의 일회성, 반복성 결정.
            enabled: true //버튼활성유무
        };

        //var optionJson = element.dataset["sgOptions"];
        var optionJson = element.getAttribute("data-sg-options");
        var options = optionJson ? JSON.parse(optionJson) : {};
        for (var o in defaultOptions) {
            if (options[o] == undefined) options[o] = defaultOptions[o];
        }
        return options;
    }

    //현재.. hideBtn의 속성값 sg-onimg에 동작. //sg-onimg에는 id가 들어옴
    //flag에따라 보이고 숨기고 함
    function sg_onImg(element, flag) {
        if (!element) {
            throw "sg_onImg에서 element값이 " + element;
            return;
        }
        //var onimgSelector = element.dataset["sgOnimg"];
        var onimgSelector = element.getAttribute("data-sg-onimg");
        if (onimgSelector != undefined) {
            if (flag) $(onimgSelector).show();
            else $(onimgSelector).hide();
        }
    }

    //현재.. hideBtn의 속성값 sg-swapimg에 동작. //sg-swapimg에는 selector가 들어옴
    //해당 img태그는 sg-src 속성값을 가지고, src와 스왑시켜 이미지를 바꿈
    function sg_swapImg(element, playFlag) {
        if (!element) {
            throw "sg_swapImg에서 element값이 " + element;
            return;
        }
        //var swapimgSelector = element.dataset["sgSwapimg"];
        var swapimgSelector = element.getAttribute("data-sg-swapimg");
        if (swapimgSelector != undefined) {

            if (playFlag) sg.swapImg(swapimgSelector);
            else {
                var img = new Image();
                img.src = $(swapimgSelector).attr("data-sg-src");
                try {
                    img.load();
                } catch (e) {
                    console.log(e)
                };
            }
        }
    }


    app.btnInit = function btnInit(target, abil) {
        var $me = $(target);
        var options = getOptions(target);
        $me.data("options", options);
        $me.data("isSg", true);

        if (options.enabled) $me.css("cursor", "pointer");
        else $me.css("cursor", "default");

    }

    return app;
});