'use strict';
define(['jquery', 'jquery-drag','jquery-hittest','jquery-scrollLock'], function($, sound, buttonsManager) {


	var app = {};
								console.log( $(this) );

	function calculatePosition(objElement, strOffset) {
		var iOffset = 0;
		if (objElement.offsetParent) {
			do {
				iOffset += objElement[strOffset];
				objElement = objElement.offsetParent;
			} while (objElement);
		}
		return iOffset;
	}

	app.setDraggable = function(selector, options) {

		/*
				var defaultOption = {
					revert: null,
					success: null,
					fail: null,
					dropSelector:null
				}
				*/
		//console.log(options);
		var options = options || {};
		//console.log(options);
		//var cloneVal;
		$(selector)
			.each(function(i, e) {
				var $this = $(this);
				var draggableOptions = {
					dropSelector: options.dropSelector || $this.attr("data-sg-drop-selector"),
					revert: (function() {
						var r = options.revert || $this.attr("data-sg-revert");
						return typeof r === "string" ? JSON.parse(r) : r;
					})(),
					fail: options.fail || $this.attr("data-sg-drop-fail"),
					success: options.success || $this.attr("data-sg-drop-success"),
					clone: (function() {
						var r = options.clone || $this.attr("data-sg-clone");
						return typeof r === "string" ? JSON.parse(r) : r;
					})()
				};

				//cloneVal = draggableOptions.clone ? "clone" : undefined;
				//console.log(cloneVal);
				//console.log(draggableOptions);

				$this.attr("data-sg-drop-selector", draggableOptions.dropSelector);
				$this.attr("data-sg-revert", draggableOptions.revert);
				$this.attr("data-sg-drop-fail", typeof draggableOptions.fail === "string" ? draggableOptions.fail : "");
				$this.attr("data-sg-drop-success", typeof draggableOptions.success === "string" ? draggableOptions.success : "");
				$this.attr("data-sg-clone", draggableOptions.clone);

				$this.data("draggableOptions", draggableOptions);

				$this.data("originPos", {
					left: this.offsetLeft,
					top: this.offsetTop
				});
				$this.css("overflow", "hidden");


				// 			///////////////////////////draggable////////////////////////////////////
				$this.draggable({

					helper: (function() {
						return draggableOptions.clone ? "clone" : undefined;
					})(),
					cursor: 'pointer',
					revert: function() {
						//console.log(this);
						$.scrollLock(false);
						var options = this.data("draggableOptions");
						//console.log(options);
						var failAction = options.fail;
						var successAction = options.success;
						var dropselector = options.dropSelector;
						var bool = options.revert;
						var isClone = options.clone;


						var hit = false;
						var helper = this.data("helper") || this;
						var rect = helper.getRect();
						if (dropselector) {
							//드랍체크.  드래그 대상의 가운데 좌표가 드랍대상안에 들어오는지 확인
							$(dropselector).each(function(i, e) {
								if (hit) return ;

								hit = $(this).hitTestPoint({
									x: rect.x + rect.width * 0.5 * sg.scaleX,
									y: rect.y + rect.height * 0.5 * sg.scaleY,
									transparency: false,
									scaleX: sg.scaleX,
									scaleY: sg.scaleY
								});
								/*
 									hit = $(this).hitTestObject({
 										selector: this,
 										transparency: false,
 										scaleX: sg.scaleX,
 										scaleY: sg.scaleY
 									});
 									*/
							});

							//console.log(hit);
						}


						if(hit){
							var $clone = this.clone();
							bool = false;
							var newOriginPos;
							if(this.css("position") == "absolute"){
								var nop = {
									left: hit[0].offsetLeft + ( hit.width() - this.width() ) * 0.5,
									top: hit[0].offsetTop + ( hit.height() - this.height() ) * 0.5
								};
								this.css( nop ).data("originPos", nop);
							}else{
								//position이 'relative'일 경우의 drop처리
								//newOriginPos는 revert처리시 사용할 새로운 위치
								var or = this.data("originPos");
								newOriginPos = {
									left: hit[0].offsetLeft - or.left + (hit[0].offsetWidth - this[0].offsetWidth) * 0.5,
									top: hit[0].offsetTop - or.top + (hit[0].offsetHeight - this[0].offsetHeight) * 0.5
								};
								this.data("newOriginPos", newOriginPos);
								
								if(isClone){
									this.css( "position", "relative" ).css( newOriginPos );
								}else{
									this.css( newOriginPos );
								}
								
							}
													
							
							if(successAction){
								if(typeof successAction == "function"){
									successAction.apply($clone[0]); 
								}else{
									eval(successAction);
								}
							}
						} else if (!hit && failAction) {
							if (typeof failAction == "function") {
								failAction.apply(this[0]);
							} else {
								eval(failAction);
							}
						}


						if(bool){
							var nop;
							if(isClone){
								bool = false;
								if(this.data("newOriginPos")){
									nop = {
										left: this[0].offsetLeft,
										top: this[0].offsetTop
									}
									//this.data("originPos", nop);
									this.data("newOriginPos", nop);
								}else{
									nop = this.data("originPos");
								}
								helper.clone().appendTo(helper.parent()).animate(nop, {complete:function(){this.remove()}});
							}else{
								if(this.css("position") == "absolute"){
									bool = false;
									this.animate(this.data("originPos"));
								}else if(nop = this.data("newOriginPos")){
									//drop이후에는 revert 위치를 다르게.
									bool = false;
									this.animate(nop);
								}
							}
						}

						



						return bool;
					},
					start : function(e, ui){
						var $this = $(this);
						$.scrollLock(true);
						//console.log(ui.helper);
						var op = $this.data("draggableOptions");
						
						if($this.css("position") != "absolute" && !op.clone){
							ui.position.left *= sg.scaleX;
							ui.position.top *= sg.scaleY;
						}
						
						$this
						.data("disPos", {
							left: ui.position.left - e.clientX,
							top: ui.position.top - e.clientY
						}).css("z-index", sg.zidx++);
						
						
						
						if(op && op.clone){
							$this.data("helper", ui.helper);
						}
						
					},
					drag: function(e, ui) {
						var disPos = $(this).data("disPos");
						ui.position = {
							left: (disPos.left + e.clientX) / sg.scaleX,
							top: (disPos.top + e.clientY) / sg.scaleY
						};
					}
				});

			})

	}


	app.resetDraggable= function( selector ){
			//console.log(selector);
			$(selector).each(function(i,e){
				var $this = $(this);
				//var dragObjs = $this.data("cloneObjs");
				//console.log(dragObjs);
				//for(var o in dragObjs) dragObjs[o].remove();
				var dropSelector = $this.attr("data-sg-drop-selector");
				
				$this.css("visibility", "visible");
				
				//#140813 position reset
				if($this.css("position") == "relative"){
					$this.css({left:"0px", top:"0px"});
				}else{
					$this.css($this.data("originPos"));
				}
				
				/*
				if(dropSelector){
					$(dropSelector).each(function(i,e){
						$(this).data("dragObj", null);
					});
				}
				*/
			});
	}


	app.destroyDraggable = function( selector ){
			sg.resetDraggable( selector );
			$( selector ).draggable( "disable" );
	}

	return app; 

})