/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         /**
          * Añadir los nombres de los labels
          */
          sym.setVariable("labels", {
         	content1: "Objetivos propuestos",
         	content2: "Propón tus objetivos",
         	//content3: "PÁGINA 3"
         // For example, duplicate "content3" and name it "content4". Remove the "//" before "content4" below and add the name for the new tab.	
         // content4: "Fourth Label"	
         });
         /**
          * Don't modify the code below.
          */
         // Mostrar un elemento 
         // Clear initial state
         sym.getSymbol("tab").deleteSymbol();
         // Find all large symbols in the library
         var prefix = "content"; // content1, content2 ... content99
         var allTabs = [];
         
         var symbolDefns = sym.getComposition().symbolDefns;
         for (var key in symbolDefns) {
           if (symbolDefns.hasOwnProperty(key) && key.search(new RegExp(prefix+"[0-9]{1,2}"))!=-1 ) {
             var tab = sym.createChildSymbol( "tab", "navigation" );
             //cambiar el margen según  
             tab.setVariable("contentId", key);
             sym.getVariable("firstTab") ? null : sym.setVariable("firstTab", tab);
             allTabs.push(tab);
             tab.$("btnLabel").html( sym.getVariable("labels")[key] || "undefined" );
             $tabEl = tab.getSymbolElement();
             $tabEl.data("sym", tab);
             $tabEl.css({float: "left", margin: "0 auto auto 0"});
             $tabEl.click(function(evt){
         	//poner texto según el momento de la actividad
         	//$(sym.lookupSelector("momento")).html(sym.getVariable("labels")[key] || "undefined" ); 
             	var tabSym = $(evt.currentTarget).data("sym");
             	$.each(allTabs, function(index,item) {
             		if (item != tabSym) { item.stop("normal"); item.setVariable("active", false); 
             		    }
             	});
         
         var $content = sym.$("content").empty();
             	sym.createChildSymbol(tabSym.getVariable("contentId"), "content");
             });
           }  	
         }

      });
      //Edge binding end

 

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         // Initially activate first Tab
         var firstTab = sym.getVariable("firstTab");
         firstTab.stop("active");
         firstTab.setVariable("active", true);
         sym.$("navigation").css({float: "right", width:"auto", margin: "0 20px 0 0"});
         
         objetivos = "Escribe aquí tus objetivos.";

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'content1'
   (function(symbolName) {   
   
   })("content1");
   //Edge symbol end:'content1'

   //=========================================================
   
   //Edge symbol: 'tab'
   (function(symbolName) {   
   
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // Register handler for mouse events to switch between states
         var el = sym.getSymbolElement();
         el.mouseenter(function(evt){ if (!sym.getVariable("active")) sym.stop("over");});
         el.mouseleave(function(evt){ if (!sym.getVariable("active")) sym.stop("normal");});
         el.mousedown(function(evt){ if (!sym.getVariable("active")) sym.stop("down");});
         el.click(function(evt){ sym.stop("active"); sym.setVariable("active", true); });

      });
      //Edge binding end

   })("tab");
   //Edge symbol end:'tab'

   //=========================================================
   
   //Edge symbol: 'content1_1'
   (function(symbolName) {   
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // Mostrar un elemento 
         var textArea=document.createElement("TextArea");
         textArea.id="textArea";
         textArea.value= objetivos;
         textArea.style.width= "1150px";
         textArea.style.height= "400px"; 
         textArea.style.border= "none";
         textArea.style.background= "#FFFFFF";
          textArea.style.fontSize= "42px";
         textArea.style.lineHeight= "40px";
         textArea.style.textAlign="left";
         textArea.style.margin="10px";
         textArea.style.fontFamily="Cabin";
         textArea.style.fontStyle="normal";
         textArea.style.color="#666666";
         // Mostrar un elemento 
         sym.$("objetivos_2").append(textArea);
         $("#textArea").keyup(function(){
         myValue = $('#textArea').val();
         objetivos= myValue;
         //console.log(myValue);
         });
         
         $("#textArea").focus(function() {
            $(this).val('');
         });
         
         

      });
      //Edge binding end

      })("content2");
   //Edge symbol end:'content2'

})(jQuery, AdobeEdge, "EDGE-7842103");